using System;
using System.Xml;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary
{
	/// <summary>
	/// This class represents RPC parameters - remote server variable references used in RPC requests.
	/// </summary>
	public class RpcRefParameter : RpcStringParameter
	{
		// Constants used in XML serialization/deserialization
		private const string XMLCONSTS_PARAMETER_TYPE_NAME = "ref";

		/// <summary>
		/// Shortcut constructor that does not initialize parameter value.
		/// </summary>
		/// <param name="paramPosition">RPC parameter position in remote procedure's signature.</param>	
		public RpcRefParameter( int paramPosition )
			: this( paramPosition, null ) {}

		/// <summary>
		/// Constructor allowing to specify parameter position as an integer.
		/// </summary>
		/// <param name="paramPosition">RPC parameter position in remote procedure's signature.</param>	
		/// <param name="paramValue">Parameter value - remote server global variable name.</param>
		public RpcRefParameter( int paramPosition, string paramValue )
			: base( XMLCONSTS_PARAMETER_TYPE_NAME, new ParameterPosition( paramPosition ), paramValue ) {}

		/// <summary>
		/// Source parameter XML node to deserialize parameter from.
		/// </summary>
		/// <param name="parameterNode"></param>
		public RpcRefParameter( XmlNode parameterNode )
			: base( XMLCONSTS_PARAMETER_TYPE_NAME, parameterNode ) {}

		/// <summary>
		/// This method is used during XML deserialization to recognize parameter XML.
		/// It tests supplied string for match with parameter type name and 
		/// returns true when there is a match.
		/// </summary>
		/// <param name="parameterTypeName">String to tests (expected to be a parameter type name).</param>
		/// <returns>True if supplied string matches parameter type name.</returns>
		public static new bool DoesParameterTypeNameMatch( string parameterTypeName )
		{
			return parameterTypeName == XMLCONSTS_PARAMETER_TYPE_NAME;
		}
	}
}
